'use strict';

angular.module('genisis', [
    'ngRoute',
    'ngCookies',
    'genisis.environment'
  ])
  .config(['$routeProvider', 'ENV',
    function ($routeProvider, ENV) {
      if (ENV.name !== 'production') {
        $routeProvider
          .when('/dashboard', {
            templateUrl: 'dashboard/dashboard.html'
          })
          .when('/requests', {
            templateUrl: 'requests/requests.html'
          })
          .when('/myRequests', {
            templateUrl: 'requests/myRequests.html'
          })
          .when('/requests/:id', {
            templateUrl: 'requests/editRequest.html'
          })
          .when('/createRequest', {
            templateUrl: 'requests/createRequest.html'
          })
          .when('/requestHistory/:id', {
            templateUrl: 'requests/requestHistory.html'
          })
          .when('/studyApprovals', {
            templateUrl: 'studies/studyApproval.html'
          })
          .when('/studyApprovals/:id', {
            templateUrl: 'studies/editStudyApproval.html'
          })
          .when('/createStudy', {
            templateUrl: 'studies/createStudyApproval.html'
          })
          .when('/login', {
            templateUrl: 'login/login.html'
          }).
        when('/logout', {
            templateUrl: 'logout/logout.html'
          })
          .when('/', {
            templateUrl: 'sso/sso.html'
          })
          .otherwise('/', {
            templateUrl: 'sso/sso.html'
          });
      } else {
        $routeProvider
          .when('/dashboard', {
            templateUrl: 'dashboard/dashboard.html'
          })
          .when('/requests', {
            templateUrl: 'requests/requests.html'
          })
          .when('/requests/:id', {
            templateUrl: 'requests/editRequest.html'
          })
          .when('/createRequest', {
            templateUrl: 'requests/createRequest.html'
          })
          .when('/requestHistory/:id', {
            templateUrl: 'requests/requestHistory.html'
          })
          .when('/studyApprovals', {
            templateUrl: 'studies/studyApproval.html'
          })
          .when('/studyApprovals/:id', {
            templateUrl: 'studies/editStudyApproval.html'
          })
          .when('/createStudy', {
            templateUrl: 'studies/createStudyApproval.html'
          })
          .when('/', {
            templateUrl: 'sso/sso.html'
          })
          .otherwise('/', {
            templateUrl: 'sso/sso.html'
          });
      }

    }
  ])
  .factory('focus', function ($timeout, $window) {
    return function (id) {
      // timeout makes sure that it is invoked after any other event has been triggered.
      // e.g. click events that need to run before the focus or
      // inputs elements that are in a disabled state but are enabled when those events
      // are triggered.
      $timeout(function () {
        var element = $window.document.getElementById(id);
        if (element)
          element.focus();
      });
    };
  });